definition module scheduler


//	Version 1.0

//	Process creation, termination, and handling functions.

import	devicefunctions, id, StdMaybe
from	StdString		import String
from	iostate			import PSt, IOSt, RR, Groups, GroupIO, Locals, LocalIO
from	receivertable	import ReceiverTable, ReceiverTableEntry, RecLoc
from	device			import Device // RWS ---, TimerDevice, MenuDevice, WindowDevice, ReceiverDevice
from	processstack	import ProcessStack, ProcessShowState, ShowFlag, ProcessKind, InteractiveProcess, VirtualProcess
from	systemid		import SystemId
// RWS --- from	event			import Events
from	StdIOCommon		import IdFun,
								ProcessAttribute, ProcessWindowPos,
									ItemPos, ItemLoc, Fix, LeftTop, RightTop, LeftBottom, RightBottom, 
										Left, Center, Right, LeftOf, RightTo, Above, Below, 
										LeftOfPrev, RightToPrev, AbovePrev, BelowPrev, 
									ItemOffset, 
								ProcessWindowSize, ProcessWindowResize, ProcessWindowResizeFunction,
								ProcessHelp, ProcessAbout, ProcessActivate, ProcessDeactivate, ProcessClose, 
								ProcessShareGUI, ProcessNoWindowMenu, IOFunction, 
								Vector, Point, Size
// RWS ...from	mac_types		import OSEvent, OSToolbox
from osevent import OSEvents, OSEvent
from ostoolbox import OSToolbox
// ... RWS 
from ostime import OSTime	// PA+++
from	StdProcessDef	import ProcessInit, DocumentInterface, NDI, SDI, MDI


::	*Environs
	=	{	envsEvents		:: !*OSEvents
		,	envsWorld		:: !*World
		}
::	*GContext p
	=	{	groupPublic		:: p
		,	groupLocals		:: !*Locals p
		}
::	*Context
	=	{	cEnvs			:: !*Environs			// The global environments
		,	cProcessStack	:: ProcessStack			// The global process stack
		,	cMaxIONr		:: SystemId				// The global maximum system number
		,	cGroups			:: *Groups				// All process groups
		,	cSleep			:: OSSleepTime			// The current sleep time for being 'nice' on a Macintosh
		,	cModalProcess	:: Maybe SystemId		// The SystemId of the interactive process that has a modal window
//PA: changed type
		,	cReceiverTable	:: ReceiverTable		// The global receiver-process table
//PA+++
		,	cTimerTable		:: TimerTable			// The table of all currently active timers
		,	cOSTime			:: OSTime				// The current OSTime
//PA
		,	cIdSeed			:: Int					// The global id generating number (actually the World)
//PA+++
		,	cOSToolbox		:: !*OSToolbox			// The OSToolbox environment
		}


initContext		:: !(ProcessInit (PSt .l .p)) !String !(!.l,!.p) !DocumentInterface !ProcessKind !*World -> (!Context,!*OSToolbox)
/*	Generate an initial Context, given the initial actions, state, and (document/process)kind of an interactive
	process, and World.
*/

handleEvents	:: !Context !*OSToolbox -> (!Context,!*OSToolbox)
/*	Consecutively handle events until termination of all interactive processes.
*/

handleContextOSEvent :: !OSEvent !Context -> (![Int],!Context)
/*	Handle one OSEvent. Context MUST not be a final context, otherwise a runtime error occurs!
*/

closeContext	:: !Context !*OSToolbox -> *World
/*	Retrieve the final World value from the Context. Context MUST be a final context, otherwise a runtime error occurs!
*/


handleOneEventForDevices :: !(SchedulerEvent i o) !(PSt .l .p) -> (!Bool,!SchedulerEvent i o,!PSt .l .p)
/*	Apply the given event to all devices in the current interactive process.
	The Boolean result indicates whether one of the devices actually handled the event.
	The DeviceEvent result may contain a response of type [o], or an error indication.
*/


addVirtualProcess		:: !(ProcessInit (PSt .l .p)) String (.l,.p) !(PSt .l` .p`) -> PSt .l` .p`
/*	AddVirtualProcess adds a process to the process administration as a virtual process.
	For virtual processes no initial devices are created. If the initial actions of the
	virtual process attempt to create a device instance this results in a runtime error.
	Virtual processes always share the GUI of their parent process. Termination is
	detected and handled by the system.
*/

ShareGUI			:==	True
NotShareGUI			:==	False

addInteractiveProcess	:: ![ProcessAttribute (PSt .l .p)] !(ProcessInit (PSt .l .p)) String .l 
							!Bool !DocumentInterface !(PSt .l` .p ) -> PSt .l` .p
/*	AddInteractiveProcess adds a process to the process administration as an interactive process.
	For interactive processes initial devices are created. 
	The Boolean argument determines whether the process shares (ShareGUI) or not shares 
	(NotShareGUI) the GUI of the current process. If it does, then the current process
	becomes the parent process of the new process, and the new process its child.
*/


quitProcess			:: !(IOSt .l .p) -> IOSt .l .p
/*	QuitProcess removes all abstract devices that are held in the interactive process
	and takes care that all processes that share its GUI are also terminated recursively.
	The resulting IOSt is a terminal value and will be removed from the process administration.
*/


//	Context-switching operations:

::	SwitchError
	=	SwitchToYourself
	|	SwitchToDoesNotExist
	|	SwitchToReceiverDoesNotExist
	|	SwitchReceiverUnable
	|	SwitchEndsUpInDeadlock

cswitchProcess :: !SystemId !(SchedulerEvent i o) !(PSt .l .p) -> (!Maybe SwitchError, ![o], !PSt .l .p)
/*	cswitchProcess processId msgEvent pstate switches to PSt identified by processId, lets that process 
	handle the msgEvent, and switches back to pstate.
	Nothing SwitchError is returned if no exceptions were detected. 
	Exceptions are:
	-	SwitchToYourself:				processId is the current PSt. 
	-	SwitchToDoesNotExist:			no current process can be identified by processId. 
	-	SwitchToReceiverDoesNotExist:	process  exists, but receiver doesn't.
	-	SwitchReceiverUnable:			receiver exists, but is not Able.
	-	SwitchEndsUpInDeadlock:			if this process would block for the process with 
										id processId to get unblocked, a deadlock would occur.
	In all exceptional cases the PSt remains unchanged.
	Observe that in case Nothing is returned, the ps PSt component may have changed value.
*/

whileCondDoIO		:: !(Context->(Bool,Context)) !(PSt .l .p) -> PSt .l .p
/*	whileCondDoIO consecutively handles events for all interactive processes while condition holds.
	When the condition fails, switch back to the argument process. The argument process must still 
	be present when the condition fails, otherwise a run-time error will occur!
*/


//	Function threading operations:

::	Result r
	:==	(	!Bool			//	object is found
		,	!Maybe r		//	optional access information
		)

accessLocals:: !((LocalIO .p)->(Result r,LocalIO .p)) !*(Locals .p)	-> (!Result r,!*Locals .p)
accessGroups:: !(GroupIO	 ->(Result r,GroupIO)   ) !*Groups		-> (!Result r,!*Groups)
/*	Let f::(IOSt .l .p) -> (Result r,IOSt .l .p) be an IOSt access function. 
	To thread f through *Locals until fst(fst(f io)), define gLocals as follows:
	
		gLocals :: *(Locals .p) -> (Result r, *Locals .p)
		gLocals locals = accessLocals f` locals
		where	f` localIO	= (r,{localIO & localIOSt=ioState})
				where	(r,ioState)	= f localIO.localIOSt

	To thread f through *Groups until fst(fst(f io)), define gGroups as follows:
	
		gGroups :: *Groups -> (Result r, *Groups)
		gGroups groups = accessGroups f` groups
		where	f` {groupState=p, groupIO=locals} = (r, {groupState=p, groupIO=locals`})
				where	(r,locals`) = gLocals locals
*/
